<?php
class Constants
{
    const API = 'https://api.ovo.id';
	const AWS_API = 'https://apigw01.aws.ovo.id';
    const osName = 'iOS';
    const osVersion = '13.3.1';
    const appId = 'P72RVSPSF61F72ELYLZI';
    const appVersion = '3.9.1';
    const userAgent = 'OVO/3.9.1 (ovo.id; build:8139; iOS 13.3.1) Alamofire/4.7.3';
    const actionMark = 'OVO Cash';
    const pushNotif = '7c83e48253d1cd45f84ed261a4a44a6c6b3efebc6f4510911fcb72b42dae369c';
}



class OVO
{
    public $nomor;
    public $device;
    public function __construct($token,$nomor,$device = '')
    {
        $this->authToken = $token;
        $this->nomor = $nomor;
        $this->device = $device;
    }

    
    private $authToken;
    private $deviceId;
    
    public function login2FA($nomor)
    {
        $payload = array(
            'mobile' => $nomor,
            'deviceId' => $this->device
        );
        
        return self::Request(Constants::API . '/v2.0/api/auth/customer/login2FA', $payload, self::generateHeaders());
    }
    
    public function login2FAverify($refId, $otpCode, $nomor)
    {
        $payload = array(
            'refId' => $refId,
            'verificationCode' => $otpCode,
            'mobile' => $nomor,
            'osName' => Constants::osName,
            'osVersion' => Constants::osVersion,
            'deviceId' => $this->deviceId,
            'appVersion' => Constants::appVersion,
            'pushNotificationId' => Constants::pushNotif
        );
        
        return self::Request(Constants::API . '/v2.0/api/auth/customer/login2FA/verify', $payload, self::generateHeaders());
    }
    public function loginSecurityCode($securityCode, $updateAccessToken)
    {
        $payload = array(
            'deviceUnixtime' => time(),
            'securityCode' => $securityCode,
            'updateAccessToken' => $updateAccessToken
        );
        
        return self::Request(Constants::API . '/v2.0/api/auth/customer/loginSecurityCode/verify', $payload, self::generateHeaders());
    }
    public function getDevice()
    {
        $deviceId = rand(111,999).'ff'.rand(111,999).'-b7fc-3b'.rand(11,99).'-b'.rand(11,99).'d-'.rand(1111,9999).'d2fea8e5';
        return $deviceId;
    }

    public function sendRequest2FA($nomor)
    {
        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_PROXY, "proxy.rapidplex.com:3128");
        //curl_setopt($ch, CURLOPT_PROXYUSERPWD, "user:domainesia");
        curl_setopt($ch, CURLOPT_URL, "https://api.ovo.id/v1.1/api/auth/customer/login2FA");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, '{"deviceId":"'.$this->device.'","mobile":"'.$this->nomor.'"}');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'App-Version: 3.36.0',
            'Os: Android',
            'Content-Type: application/json; charset=UTF-8',
            'Host: api.ovo.id',
            'User-Agent: okhttp/3.11.0',
        ]);
        $result = curl_exec($ch);
        $reshttp = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return ($reshttp == 200) ? true : false;
    }

    public function konfirmasiCode($device, $nomor, $verificationCode)
    {
        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_PROXY, "proxy.rapidplex.com:3128");
        //curl_setopt($ch, CURLOPT_PROXYUSERPWD, "user:domainesia");
        curl_setopt($ch, CURLOPT_URL, "https://api.ovo.id/v1.1/api/auth/customer/login2FA/verify");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, '{"deviceId":"'.$this->device.'","mobile":"'.$this->nomor.'","verificationCode":"'.$verificationCode.'"}');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'App-Version: 3.36.0',
            'Os: Android',
            'Content-Type: application/json; charset=UTF-8',
            'Host: api.ovo.id',
            'User-Agent: okhttp/3.11.0',
        ]);
        $result = curl_exec($ch);
        curl_close($ch);

        if (json_decode($result, true)['isSecurityCode']  ==  'true') {
            return true;
        } else {
            return false;
        }
    }

    public function konfirmasiSecurityCode($device, $nomor, $verificationCode)
    {
        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_PROXY, "proxy.rapidplex.com:3128");
        //curl_setopt($ch, CURLOPT_PROXYUSERPWD, "user:domainesia");
        curl_setopt($ch, CURLOPT_URL, "https://api.ovo.id/v1.1/api/auth/customer/loginSecurityCode/verify");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, '{"mobile":"'.$this->nomor.'","securityCode":"'.$securityCode.'","deviceUnixtime":1539175105,"appVersion":"3.36.0","deviceId":"'.$this->device.'","macAddress":"08:62:66:67:81:39","osName":"android","osVersion":"5.0","pushNotificationId":"FCM|e1-j8yB55QI:APA91bFan4mLCWogE4ols2OFSmz1YjgB71tKwZA0Y-IkwJSiKzG1ALJ6oxGuSQLYXLQWG8dujmdeWOdPn-gWWc_0fDcaO8BaPeZQbiF9wd3pfFU1NcYv54CUU80yPAZMS0nbNqfgHosJ"}');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'App-Version: 3.36.0',
            'Os: Android',
            'Content-Type: application/json; charset=UTF-8',
            'Host: api.ovo.id',
            'User-Agent: okhttp/3.11.0',
        ]);
        $result = json_decode(curl_exec($ch), true);
        $reshttp = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        return ($reshttp == 200) ? ['result' => true,'data' => $result['token']] : ['result' => false,'data' => $result['message']];
    }

    public function seeMutation($token,$limit = 10)
    {
        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_PROXY, "proxy.rapidplex.com:3128");
       // curl_setopt($ch, CURLOPT_PROXYUSERPWD, "user:domainesia");
        curl_setopt($ch, CURLOPT_URL, "https://api.ovo.id/wallet/v2/transaction?page=1&limit=".$limit."&productType=001");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: '.$token,
            'App-Version: 3.36.0',
            'Os: Android',
            'Host: api.ovo.id',
            'User-Agent: okhttp/3.11.0',
        ]);
        $result = json_decode(curl_exec($ch), true);
        curl_close($ch);

        $http = ($result['status'] == 200) ? true : false;
        $data = ($result['status'] == 200) ? $result['data'][0]['complete'] : $result['message'];
        return ['result' => $http,'data' => $data];
    }

    public function cekSaldo($saldo, $mutasi)
    {
        return (strpos($mutasi, $saldo) !== false) ? true : false;
    }
}